# @file
# 
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2016 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification Reference:
#

function EndPreBuild {
  cd $PLATFORM_PACKAGE
}

cd ..


#
# Set build capsule flag with default of OFF
#
CAPSULE_BUILD=0
if [ "$2" = "TRUE" ]; then
  CAPSULE_BUILD=1
fi
echo
echo "Prebuild:  Set build environment."
echo

if [ ! -d "$BUILD_DIR" ]; then
  mkdir -p $BUILD_DIR
fi

grep -v 'ACTIVE_PLATFORM\|TARGET\|TARGET_ARCH\|TOOL_CHAIN_TAG\|BUILD_RULE_CONF' Conf/target.txt > $BUILD_DIR/target.txt
if [ "$CAPSULE_BUILD" -eq "0" ]; then
  echo "ACTIVE_PLATFORM = $PLATFORM_PACKAGE/PlatformPkg.dsc"    >> $BUILD_DIR/target.txt
else
  echo "ACTIVE_PLATFORM = $PLATFORM_PACKAGE/CapsulePkg.dsc"     >> $BUILD_DIR/target.txt
fi
echo "TARGET            = $TARGET"                              >> $BUILD_DIR/target.txt
echo "TARGET_ARCH       = $TARGET_ARCH"                         >> $BUILD_DIR/target.txt
echo "TOOL_CHAIN_TAG    = $TOOL_CHAIN_TAG"                      >> $BUILD_DIR/target.txt
echo "BUILD_RULE_CONF   = Conf/build_rule.txt"                  >> $BUILD_DIR/target.txt
mv -f $BUILD_DIR/target.txt Conf

if [ "$CAPSULE_BUILD" -eq "0" ]; then
  echo
  echo "Prebuild:  Create BiosId"
  echo
  if [ ! -d "$BUILD_X64" ]; then
    mkdir -p $BUILD_X64
  fi
  #
  # TODO: Code Coverage not supported at this time
  #


  #
  # Create BiosId.env based on the build type
  #
  BIOSID_FILENAME=BiosId
  if [ "$EMBEDDED_BUILD" = "TRUE" ]; then
    BIOSID_FILENAME=BiosIdEmb
  fi
  cp -f $WORKSPACE/$PLATFORM_PACKAGE/Tools/GenBiosId/$BIOSID_FILENAME.env $BIOS_ID_FILE
  if [ "$EMBEDDED_BUILD" = "TRUE" ]; then
    echo "BOARD_ID      = SKLSDBK" >> $BIOS_ID_FILE
  else
    #
    # S = SPT, E = ERB (LPT)
    #
    PCH_TYPE=S
    BOARD_ID_STRING="BOARD_ID      = KBL$PCH_TYPE"
    BOARD_ID_STRING+="E2$BUILD"
    echo "$BOARD_ID_STRING" >> $BIOS_ID_FILE
  fi
  BOARD_EXT_STRING="BOARD_EXT    = $TARGET_SHORT"
  BOARD_EXT_STRING+="00"
  echo "$BOARD_EXT_STRING" >> $BIOS_ID_FILE
  BIOS_ID_OUTPUT_DIR=$BUILD_IA32
  if [ ! -d "$BIOS_ID_OUTPUT_DIR" ]; then
    mkdir -p $BIOS_ID_OUTPUT_DIR
  fi
  wine $BP_COMMON_PACKAGE/Tools/GenBiosId/GenBiosId.exe -i $(winepath -w $BIOS_ID_FILE) -o $(winepath -w $BIOS_ID_OUTPUT_DIR/BiosId.bin)
  ret=$?
  if [ $ret -ne 0 ]; then
    EndPreBuild
    exit $ret
  fi

  echo
  echo "Prebuild:  Create AutoGenFlashMap.h."
  echo
  build -n $NUMBER_OF_PROCESSORS $EXT_BUILD_FLAGS -m $PLATFORM_PACKAGE/BiosInfo/BiosInfo.inf
  ret=$?
  if [ $ret -ne 0 ]; then
    EndPreBuild
    exit $ret
  fi
  grep -v 'Base.h\|PiPei.h\|PiDxe.h\|PcdLib.h\|gEfiCallerIdGuid\|TOKEN\|const\|MODE EFI_CALLER_ID_GUID\|}}\|EFI_STATUS\|EFIAPI\|DummyModuleEntryPoint\|EFI_HANDLE EFI_SYSTEM_TABLE\|BiosInfoEntryPoint\|EFI_PEI_FILE_HANDLE\|EFI_PEI_SERVICES\|);' $BUILD_IA32/$PLATFORM_PACKAGE/BiosInfo/BiosInfo/DEBUG/AutoGen.h > $BUILD_DIR/AutoGenFlashMap.h
  echo
  echo "Prebuild:  Create BiosUpdateConfig."
  echo
  INI_CFLAGS="-c -E -I$PLATFORM_PACKAGE -I$BUILD_DIR"
  gcc $INI_CFLAGS -x c $PLATFORM_PACKAGE/CapsuleUpdateConfig/BiosUpdateConfig.ini -o $BUILD_X64/BiosUpdateConfig.tmp
  ret=$?
  if [ $ret -ne 0 ]; then
    EndPreBuild
    exit $ret
  fi
  #Note: This is different from the MSVC command because the output from GCC differs slightly
  grep -v '^#.*' $BUILD_X64/BiosUpdateConfig.tmp > $BUILD_X64/BiosUpdateConfig.ini
  rm $BUILD_X64/BiosUpdateConfig.tmp
  #
  # Create dummy ClientBios.fd file to pass the first build.  In post build, the real image will be generated
  #
  if [ ! -d "$BUILD_DIR/FV" ]; then
    mkdir -p $BUILD_DIR/FV
  fi
  echo 2> $BUILD_DIR/FV/CLIENTBIOS.fd
  FILENAME=$BUILD_DIR/FV/BGUP_$TARGET
  FILENAME+=_CAPSULE.bin
  echo 2> $FILENAME
fi
echo
echo "Prebuild is complete."
if [ "$CAPSULE_BUILD" -eq "0" ]; then
  echo "  ACTIVE_PLATFORM      = $PLATFORM_PACKAGE/PlatformPkg.dsc"
else
  echo "  ACTIVE_PLATFORM      = $PLATFORM_PACKAGE/CapsulePkg.dsc"
fi
echo "  EFI_SOURCE           = $EFI_SOURCE"
echo "  TARGET               = $TARGET"
echo "  TARGET_ARCH          = IA32 X64"
echo "  TOOL_CHAIN_TAG       = $TOOL_CHAIN_TAG"
echo "  WORKSPACE            = $WORKSPACE"
echo "  EXT_BUILD_FLAGS      = $EXT_BUILD_FLAGS"
echo
EndPreBuild
